Attribute VB_Name = "Module1"
'// 1. Find ROCKEY2 dongles attached to the computer
Declare Function RY2_Find Lib "ROCKEY2.DLL" () As Long
'//return value
'// <0  Error code
'// =0  No ROCKEY2 dongle is attached
'// >0  The number of attached ROCKEY2 dongle(s)
'// ====================================================================
'
'// 2. Open specified ROCKEY2 dongle

Declare Function RY2_Open Lib "ROCKEY2.DLL" (ByVal mode As Long, ByVal uid As Long, ByRef hid As Long) As Long

'// input:
'// mode----This parameter indicates the way to open the dongle
'// mode = 0, open the first found ROCKEY2 dongle
'// mode > 0, open the dongle according to the UID. The mode value is the dongle number,
'//           for example: uid=12345678, mode=2, this means it will open the second dongle with UID 12345678
'// mode = -1, open the dongle according to the HID, and *hid can not be 0
'//We defined two MACROs:
Global Const AUTO_MODE = 0

Global Const HID_MODE = -1
'// uid---UserID,You need to specify the dongle UID and this UID is generated with RY2_GenUID
'// hid---Hardware ID,Open dongle with HID of *hid
'// The dongle HID will be returned to *hid regardless of how the dongle was opened.
'// return vaule:
'// >=0 Success. The opened dongle handle is returned.
'// < 0 Error code. Please refer to the later
'// ====================================================================
'
'// 3. Close specified ROCKEY2 dongle
Declare Sub RY2_Close Lib "ROCKEY2.DLL" (ByVal handle As Long)
'// Input:
'// handle---ROCKEY2 dongle handle. It is the handle returned from RY2_Open
'// Return:
'// Error code. Please refer to the later

'// ====================================================================
'
'// 4. Generate User ID(UID)
Declare Function RY2_GenUID Lib "ROCKEY2.DLL" (ByVal handle As Long, ByRef uid As Long, ByVal seed As Any, ByVal isProtect As Long) As Long
'// input:
'// handle---Dongle handle. It is the handle returned from RY2_Open.
'// uid---Output parameter. The generated UID.
'// seed---Seed to generate UID. It is a character string with the maximum length of 64 bytes
'// isProtect---Sets write protection. 0=dongle not write protected, 1=dongle write protected.
Global Const ROCKEY2_DISABLE_WRITE_PROTECT = 0
Global Const ROCKEY2_ENSABLE_WRITE_PROTECT = 1
'// Return:
'// Error code. Please refer to the later
'
'// ====================================================================

'// 5. Read dongle content

Declare Function RY2_Read Lib "ROCKEY2.DLL" (ByVal handle As Long, ByVal block_index As Integer, ByVal buffer512 As Any) As Long
'// input:
'// handle---Dongle handle. It is the handle returned from RY2_Open.
'// block_index---Block index. Specify the block to read. The value range is 0-4.
'// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
'// Return:
'// Error code. Please refer to the later

'// ====================================================================
'
'// 6. Write to ROCKEY2 dongle

Declare Function RY2_Write Lib "ROCKEY2.DLL" (ByVal handle As Long, ByVal block_index As Integer, ByVal buffer512 As Any) As Long

'// input:
'// handle---Dongle handle. It is the handle returned from RY2_Open
'// block_index---Block index. Specify the block to read. The value range is 0-4.
'// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
'// Return:
'// Error code. Please refer to the later
'
'
'// Error code ===========================================================
'
'// Success
Global Const RY2ERR_SUCCESS = 0
'
'// Specified dongle is not found (parameter error)
Global Const RY2ERR_NO_SUCH_DEVICE = &HA0100001
'
'// Need to call RY2_Open first to open the dongle, then call this function (operation error)
Global Const RY2ERR_NOT_OPENED_DEVICE = &HA0100002
'
'// Wrong UID(parameter error)
Global Const RY2ERR_WRONG_UID = &HA0100003
'
'// Block index error (parameter error)
Global Const RY2ERR_WRONG_INDEX = &HA0100004
'
'// Seed character string is longer than 64 bytes when calling GenUID (parameter error)
Global Const RY2ERR_TOO_LONG_SEED = &HA0100005
'
'// Tried to write to write-protected dongle(operation error)
Global Const RY2ERR_WRITE_PROTECT = &HA0100006
'
'// Open device error (Windows error)
Global Const RY2ERR_OPEN_DEVICE = &HA0100007
'
'// Read record error(Windows error)
Global Const RY2ERR_READ_REPORT = &HA0100008
'
'// Write record error(Windows error)
Global Const RY2ERR_WRITE_REPORT = &HA0100009
'
'// Internal error (Windows error)
Global Const RY2ERR_SETUP_DI_GET_DEVICE_INTERFACE_DETAIL = &HA010000A
'
'// Internal error (Windows error)
Global Const RY2ERR_GET_ATTRIBUTES = &HA010000B
'
'// Internal error (Windows error)
Global Const RY2ERR_GET_PREPARSED_DATA = &HA010000C
'
'// Internal error (Windows error)
Global Const RY2ERR_GETCAPS = &HA010000D
'
'// Internal error (Windows error)
Global Const RY2ERR_FREE_PREPARSED_DATA = &HA010000E
'
'// Internal error (Windows error)
Global Const RY2ERR_FLUSH_QUEUE = &HA010000F
'
'// Internal error (Windows error)
Global Const RY2ERR_SETUP_DI_CLASS_DEVS = &HA0100010
'
'// Internal error (Windows error)
Global Const RY2ERR_GET_SERIAL = &HA0100011
'
'// Internal error (Windows error)
Global Const RY2ERR_GET_PRODUCT_STRING = &HA0100012
'
'// Internal error (Windows error)
Global Const RY2ERR_TOO_LONG_DEVICE_DETAIL = &HA0100013
'
'// Unknown device(hardware error)
Global Const RY2ERR_UNKNOWN_DEVICE = &HA0100020
'
'// Verification error(hardware error)
Global Const RY2ERR_VERIFY = &HA0100021
'
'// Unknown error(hardware error)
Global Const RY2ERR_UNKNOWN_ERROR = &HA010FFFF
'
